#include <stdio.h>
#include <string.h>
#include "lib.h"

char bcrBuffer[4100];
extern int OutBreakPacketBltHid(void);
unsigned char CheckBltAddress(char *c);
int BluetoothConnect(int port, char *bdAddress, char *pincode, unsigned char reconnect, int iphoneMode);
void main( void )
{
	struct barcodeEx bcr;
	int recvData;
	char bdAddress[20];
	int scanBd = FALSE;
	int loop = TRUE;
	int mfiStatus;
	int prevMfiStatus = iAP2_EASs_NONE;
	OsStatus(ON);
	printf("[MFi sample]\r\n");
	ScannerPower(SINGLE, 3 * 50);
	memset(&bcr, 0, sizeof(bcr));
	bcr.text = bcrBuffer;
	bcr.min = 1;
	printf("Read BD address\r\n");
	while (loop)
	{
		/** ----- Read Bluetooth address ----- **/
		bcr.max = 12;
		while (scanBd == FALSE){
			if (ReadBarcodeEx(&bcr) == OK){
				printf(bcr.text);
				printf("\r\n");
				if (bcr.length == 6){
					memset(bdAddress, 0x00, sizeof(bdAddress));
					memcpy(bdAddress, "00126A", 6 );
					memcpy(&bdAddress[6], (char *)bcrBuffer, 6);
				}else if (bcr.length == 12){
					memcpy(bdAddress, (char *)bcrBuffer, 12);
				}else{
					continue;
				}
				for (int i = 0; i < 12; i++){
					if (CheckBltAddress((char *)&bdAddress[i]) == FALSE){
						scanBd = FALSE;
						break;
					}else{
						scanBd = TRUE;
					}
				}
			}
			Idle();
		}
		ScannerPower(OFF, 0);
		/** ----- Connect Bluetooth MFi (SPP Master) ----- **/
		while (BluetoothConnect(COM3, bdAddress, NULL, DISABLE, /*DISABLE_IPHONE_MODE*/ENABLE_IPHONE_MODE_SPP_MASTER) != OK)	Idle();
		Cursor(AUTOWRAP);
		bcr.max = 4000;
		ScannerPower(SINGLE, 3 * 50);
		/** ----- Bluetooth MFi data transfer test ----- **/
		while (1){
			mfiStatus = GetMfiAccessoryStatus();
			if (mfiStatus != iAP2_EASs_CONNECT){
				if (prevMfiStatus != mfiStatus){
					printf("Accessory close\r\n");
					ScannerPower(OFF, 0);
				}
			}else{
				if (prevMfiStatus != mfiStatus){
					printf("Accessory open\r\n");
					ScannerPower(SINGLE, 3 * 50);
					printf("Waiting receive host:\r\n");
				}
				/** ----- Data receive ----- **/
				while ((recvData=GetCom(0)) >= 0){
					if (recvData > ' ' && recvData < 0x7f){
						int prevColor = SetTextColor(RGB_BLUE);
						putchar(recvData & 0xFF);
						SetTextColor(prevColor);
					}
				}
				if (ReadBarcodeEx(&bcr) == OK){
					/** ----- Barcode data send ----- **/
					AccessoryDataTransfer(bcr.text, bcr.length);
					printf(bcr.text);
					printf("\r\n");
				}
				char c;
				if (kbhit() && (c = getchar()) != 0){
					if (c == BS_KEY){
						/** ----- Test end ----- **/
						printf("ComClose\r\nApplication finished\r\n");
						ComClose(COM3);
						Cursor(NOWRAP);
						loop = FALSE;
						ResetKey();
						while(!kbhit())
							Idle();
						break;
					}
					if (c < SCAN_KEY){
						/** ----- Key char send ----- **/
						AccessoryDataTransfer(&c, 1);
						putchar(c);
					}
				}
			}
			if (GetConnectionStatus(COM3) != COM_STATE_CONNECT)
			{
				printf("Disconnected\r\n");
				Cursor(NOWRAP);
				ComClose(COM3);
				break;
			}
			prevMfiStatus = mfiStatus;
			Idle();
		}
	}
}
unsigned char CheckBltAddress(char *c)
{
	if ((*c >= '0') && (*c <= '9'))	return TRUE;
	if ((*c >= 'A') && (*c <= 'F'))	return TRUE;
	if ((*c >= 'a') && (*c <= 'f'))
	{
		*c -= ('a' - 'A');
		return TRUE;
	}
	return FALSE;
}
int BluetoothConnect(int port, char *bdAddress, char *pincode, unsigned char reconnect, int iphoneMode)
{
    int status;
	int prevStatus = -1;
	setconfig_comapi spp_cfg;
	SetDefault(port);
    if(GetConnectionStatus(port) == COM_STATE_CLOSE){
		GetConfig(port, (void *)&spp_cfg);
		if (/*port == COM3 && */bdAddress != NULL){	// BD address if SPP master mode
			strncpy((char *)spp_cfg.blt.address, bdAddress, BLT_BD_ADDR_LEN);
		}
		if (pincode != NULL){
			spp_cfg.blt.dynamicPIN = FALSE;
			strncpy((char *)spp_cfg.blt.pincode, pincode, BLT_MAX_PINCODE_LEN);
		}
		if (port == COM4 || port == COM5){// HID or SPP Slave
			spp_cfg.blt.pairedDeviceConnect = reconnect;// DISABLE:Do pairing / ENABLE:Reconnect preview paring device
		}else{// SPP Master (COM3)
			spp_cfg.blt.pairedDeviceConnect = DISABLE;
		}
		if (port == COM4){// HID
			strcpy((char *)spp_cfg.blt.classOfDevice, "000540");// Must set for Bluetooth HID
			/*** Workaround for Bluetooth HID issue ***/
			spp_cfg.hid.caps_mode      = HID_CAPS_MODE_NOCAPS;
			spp_cfg.hid.num_mode       = HID_NUM_MODE_NONUM;
		}
		spp_cfg.blt.iPhoneMode = iphoneMode;
		SetConfig(port, (void *)&spp_cfg);
		if (ComOpen(port) != OK){
			ComClose(port);
			return ERROR;
		}
    }
    BltWaitAcceptStart();
    while (1){
        status = GetConnectionStatus(port);
        if (status != prevStatus){
        	printf("connect status:%d\r\n", status);
        	prevStatus = status;
        }
        if (status == COM_STATE_CONNECT){
        	BltWaitAcceptEnd(TRUE);
        	if (port == COM4){
        		/*** Workaround for Bluetooth HID issue ***/
        		OutBreakPacketBltHid();
        	}
            break;
        }else if (status == COM_STATE_CLOSE){
        	BltWaitAcceptEnd(TRUE);
            ComClose(port);
            return ERROR;
        }
        Idle();
    }
    return OK;
}
