/*
 * logapi.h
 *
 * Copyright (C) 2019 OPTOELECTRONICS CO.,LTD. All rights reserved.
 */

#ifndef __LOGAPI_H_
#define __LOGAPI_H_

#include <stdbool.h>

#define LOG_PRINTF(bPrint, ...) Logmem_printf_App(bPrint, __VA_ARGS__)
#define LOG_PRINTF_T(bPrint, ...) Logmem_printf_App_T(bPrint, __VA_ARGS__)
#define LOG_HEAP_SUMMARY() LogHeap_Summary()
#define LOG_API_DISABLE_ALL() LogApi_DisableAllFunc()
#define LOG_API_ENABLE_ALL() LogApi_EnableAllFunc()
#define LOG_API_ENABLE(a) LogApi_EnableFunc(a)
#define LOG_API_DISABLE(a) LogApi_DisableFunc(a)

extern void Logmem_printf_App(bool bPrint, const char* fmt, ...);
extern void Logmem_printf_App_T(bool bPrint, const char* fmt, ...);
extern void LogHeap_Summary(void);
extern void LogApi_DisableAllFunc(void);
extern void LogApi_EnableAllFunc(void);
extern bool LogApi_EnableFunc(int funcNr);
extern bool LogApi_DisableFunc(int funcNr);

#endif /* __LOGAPI_H_ */
